/******************************************************************
 * Copyright (c) 2021
 * All rights reserved.
 
 * Filename: algorithm.cpp
 
 * Version: 1.0
 * Author: Yang Zhang  (zhangyang@big.ac.cn)
 * Date: December, 2021
 
 ******************************************************************/
#include <stdio.h>
#include "algorithm.h"



float** CreateGrid2_malloc(int m,int n){
    int i = 0;
    float** tt = NULL;
    if((m > 0) && (n > 0)){
        tt = (float**)malloc(sizeof(float)*m);
        for(i = 0;i < m;i++){tt[i] = (float*)malloc(sizeof(float)*n);}
    }
    return tt;
}

void FreeGrid2_malloc(float** tt,int m,int n){
    int i = 0;
    if(tt != NULL){
        for(i = 0;i < m;i++){free(tt[i]); }
        free(tt);
        tt = NULL;
    }
}


float** CreateGrid2(int m,int n){
    float **tt = new float *[m];
    for (int i = 0;i <m;i++){tt[i] = new float[n];}
    return tt;
}
void FreeGrid2(float** tt,int m,int n){
    if (tt!=NULL) {
        for (int i = 0;i< m;i++){
            delete[]tt[i];
            
        }
        delete []tt;
        tt=NULL;
    }
}



int** CreateGrid2_int(int m,int n){
    int **tt = new int *[m];
    for (int i = 0;i <m;i++){tt[i] = new int[n];}
    return tt;
}
void FreeGrid2_int(int** tt,int m,int n){
    if (tt!=NULL) {
        for (int i = 0;i< m;i++){delete[]tt[i];}
        delete []tt;
        tt=NULL;
    }
}




float*** CreateGrid3(int m,int n,int t){

    
    float ***p = NULL;  // p[pen_num][row][col];
    int i, j;
    int pen_num = m, row = n, col = t;
    
    
    p = (float ***)malloc(pen_num * sizeof(float **));
    if (NULL == p)
    {
        printf("malloc fail\n");
        
    }
    
    for (i = 0; i < pen_num; ++i)
    {
       
        p[i] = (float **)malloc(row * sizeof(float *));
        if (NULL == p[i])
        {
            printf("malloc fail\n");
            
        }
        
        for (j = 0; j < row; ++j)
        {
           
            p[i][j] = (float *)malloc(col * sizeof(float));
            if (NULL == p[i][j])
            {
                printf("malloc fail\n");
                
            }
        }
        
    }
 
    return p;
}


void FreeGrid3(float*** tt,int m,int n,int t){
    int i;
    int j;
   
    for (i = 0; i < m; ++i)
    {
        for (j = 0; j < n; ++j)
        {
            free(tt[i][j]);
        }
    }
    
    for (i = 0; i < m; ++i)
    {
        free(tt[i]);
    }
    free(tt);
    tt = NULL;
    
}

float**** CreateGrid4(int m,int n,int t,int w){
    
    
    float ****p = NULL;
    int i, j, k;
    
    
    
    p = (float ****)malloc(m * sizeof(float ***));
    if (NULL == p)
    {
        printf("malloc fail\n");
        
    }
    
    for (i = 0; i < m; ++i)
    {
        
        p[i] = (float ***)malloc(n * sizeof(float **));
        if (NULL == p[i])
        {
            printf("malloc fail\n");
            
        }
        
        for (j = 0; j < n; ++j)
        {
            
            p[i][j] = (float **)malloc(t * sizeof(float*));
            if (NULL == p[i][j])
            {
                printf("malloc fail\n");
                
            }
            for (k = 0; k < t; ++k)
            {
                
                p[i][j][k] = (float *)malloc(w * sizeof(float));
                if (NULL == p[i][j][k])
                {
                    printf("malloc fail\n");
                    
                }
            }
        }
        
    }
    
    return p;
}


void FreeGrid4(float**** tt,int m,int n,int t,int w){
    int i;
    int j;
    int k;
    
    for (i = 0; i < m; ++i)
    {
        for (j = 0; j < n; ++j)
        {
            for (k = 0; k < t; ++k)
            {
                free(tt[i][j][k]);
            }
        }
    }
    for (i = 0; i < m; ++i)
    {
        for (j = 0; j < n; ++j)
        {
          free(tt[i][j]);
            
        }
    }
    
    for (i = 0; i < m; ++i)
    {
        free(tt[i]);
    }
    free(tt);
    tt = NULL;
    
}


int*** CreateGrid3_int(int m,int n,int t){
    
    
    int ***p = NULL;  // p[pen_num][row][col];
    int i, j;
    int pen_num = m, row = n, col = t;
    
    
    p = (int ***)malloc(pen_num * sizeof(int **));
    if (NULL == p)
    {
        printf("malloc fail\n");
        
    }
    
    for (i = 0; i < pen_num; ++i)
    {
        
        p[i] = (int **)malloc(row * sizeof(int *));
        if (NULL == p[i])
        {
            printf("malloc fail\n");
            
        }
        
        for (j = 0; j < row; ++j)
        {
            
            p[i][j] = (int *)malloc(col * sizeof(int));
            if (NULL == p[i][j])
            {
                printf("malloc fail\n");
                
            }
        }
        
    }
    
    return p;
}


void FreeGrid3_int(int*** tt,int m,int n,int t){
    int i;
    int j;
    
    for (i = 0; i < m; ++i)
    {
        for (j = 0; j < n; ++j)
        {
            free(tt[i][j]);
        }
    }
    
    for (i = 0; i < m; ++i)
    {
        free(tt[i]);
    }
    free(tt);
    tt = NULL;
    
}


float*** CreateGrid3_c(int m,int n,int t){
    float ***p;
    p = new float **[m];
    for(int i=0; i<m; ++i){
        p[i]=new float *[n];
        for(int j=0; j<n; ++j){
            p[i][j]=new float[t];
        }
    }
    return p;
}

void FreeGrid3_c(float*** p,int m,int n,int t){
    if(p!=NULL){
       for(int i=0; i<m; ++i)
       {
           for(int j=0; j<n; ++j)
           {
               delete[] p[i][j];
           }
       }
       for(int i=0; i<m; ++i)
       {
           delete [] p[i];
       }
       delete [] p;
    }
}



//One-dimensional array to calculate Euclidean distance
float EuclideanDis(float*a,float*b,int col){
    float dis=0;
    for (int i=0; i<col; ++i) {
        dis+=(a[i]-b[i])*(a[i]-b[i]);
    }
    dis=sqrt(dis);
    return dis;
}

//Two-dimensional array pairwise row distance, return an upper triangular matrix
float** TowDimensionDis(float**dis,float**a,int row,int col){
    for (int i=0; i<row; ++i) {
        for (int j=i+1; j<row; ++j) {
            dis[i][j]=EuclideanDis(a[i], a[j], col);
        }
    }
    return dis;
}

void GridJoint(float **a, int row, int startCol, float ***b,int col,int depthId){
    int sCol;
    for (int i=0; i<row; ++i) {
        sCol=startCol;
        for (int j=0; j<col; ++j) {
            a[i][sCol]=b[i][j][depthId];
            sCol++;
        }
    }
}

void GridTrans(float **tranData, float *** rawData, int row, int col, int depth){
    int startCol=0;
    for (int i=0; i<depth; ++i) {
        startCol=col*i;
        GridJoint(tranData, row, startCol, rawData, col,i);
        
    }
    
}

//Quickly sort and store subscripts (from small to large)
void QuickSort(float* iArray,int left, int right,int*sortIndex) {
    if (left >= right) { return; }
    float piovt = iArray[left];
    int piovtIndex=sortIndex[left];
    int leftIndex = left;
    int rightIndex = right;
    while (leftIndex < rightIndex) {
        while (leftIndex < rightIndex) {
            if (piovt <= iArray[rightIndex]) {
                rightIndex--;
            }
            else {
                iArray[leftIndex] = iArray[rightIndex];
                sortIndex[leftIndex]=sortIndex[rightIndex];
                leftIndex++;
                break;
            }
        }
        while (leftIndex < rightIndex) {
            if (piovt >= iArray[leftIndex]) { leftIndex++; }
            else {
                iArray[rightIndex] = iArray[leftIndex];
                sortIndex[rightIndex]=sortIndex[leftIndex];
                rightIndex--;
                break;
            }
        }
    }
    iArray[leftIndex] = piovt;
    sortIndex[leftIndex]=piovtIndex;
    QuickSort(iArray, left, leftIndex - 1,sortIndex);
    QuickSort(iArray, rightIndex + 1, right,sortIndex);
}

//Quickly sort and store subscripts (from largest to smallest)
void QuickSort_top(float* iArray,int left, int right,int*sortIndex) {
    if (left >= right) { return; }
    float piovt = iArray[left];
    int piovtIndex=sortIndex[left];
    int leftIndex = left;
    int rightIndex = right;
    while (leftIndex < rightIndex) {
        while (leftIndex < rightIndex) {
            if (piovt >= iArray[rightIndex]) {
                rightIndex--;
            }
            else {
                iArray[leftIndex] = iArray[rightIndex];
                sortIndex[leftIndex]=sortIndex[rightIndex];
                leftIndex++;
                break;
            }
        }
        while (leftIndex < rightIndex) {
            if (piovt <= iArray[leftIndex]) { leftIndex++; }
            else {
                iArray[rightIndex] = iArray[leftIndex];
                sortIndex[rightIndex]=sortIndex[leftIndex];
                rightIndex--;
                break;
            }
        }
    }
    iArray[leftIndex] = piovt;
    sortIndex[leftIndex]=piovtIndex;
    QuickSort_top(iArray, left, leftIndex - 1,sortIndex);
    QuickSort_top(iArray, rightIndex + 1, right,sortIndex);
}



//Bubble sort and store subscript
void BubbleSort(float *p, int length, int * ind_diff){
    for (int m = 0; m < length; m++){ind_diff[m] = m;}
    for (int i = 0; i < length; ++i){
        for (int j = 0; j < length- i - 1; ++j){
            if (p[j] > p[j + 1]){
                float temp = p[j];
                p[j] = p[j + 1];
                p[j + 1] = temp;
                int ind_temp = ind_diff[j];
                ind_diff[j] = ind_diff[j + 1];
                ind_diff[j + 1] = ind_temp;
            }
        }
    }
}
//Bubble sort only stores subscripts, from largest to smallest
void BubbleSort2(float  *p, int length, int * ind_diff){
//    for (int m = 0; m < length; m++){ind_diff[m] = m;}
    for (int i = 0; i < length; ++i){
        for (int j = 0; j < length- i - 1; ++j){
            if (p[j] < p[j + 1]){
//                float temp = p[j];
//                p[j] = p[j + 1];
//                p[j + 1] = temp;
                int ind_temp = ind_diff[j];
                ind_diff[j] = ind_diff[j + 1];
                ind_diff[j + 1] = ind_temp;
            }
        }
    }
}


void copyData(float*** &data_copy,float*** data,int row,int col,int depth){
    for (int i=0; i<row; ++i) {
        for (int j=0; j<col; ++j) {
            for (int w=0; w<depth; w++) {
                data_copy[i][j][w]=data[i][j][w];
            }
        }
    }
}

void dataTrans(float*** &data_trans,float*** data,int row,int col,int depth){
    
}

/*1 dimensional data standardization*/
void Standardize_score(float* &data,int row,float cut){
  
    float a=data[0];
    float b=data[0];

    for(int i=0;i<row;i++){
        if(data[i]>a){a=data[i];}
        if(data[i]<b){
            b=data[i];
        }
        
    }
    a=a+cut;
            for(int i=0;i<row;i++){
                if(data[i]-b==0){data[i]=0;}
                else{
                    data[i]=(data[i]-b)/(a-b);
                }
                
            }
  
  
}

/* 用x替换a */
string replaceAWithX(string str,string a,string x){
    int pos= str.find(a);
    while(pos != -1){
        // str.length()求字符的长度，注意str必须是string类型
        str.replace(pos,string(a).length(),x);
        pos = str.find(a);
    }

    return str;
}

