/******************************************************************
 * Copyright (c) 2021
 * All rights reserved.
 
 * Filename: algorithm.h
 
 * Version: 1.0
 * Author: Yang Zhang  (zhangyang@big.ac.cn)
 * Date: December, 2021
 
 ******************************************************************/


#ifndef algorithm_h
#define algorithm_h
#include <algorithm>
#include <stdio.h>
#include <string>
#include <sstream>
#include<math.h>

//#include "base.h"

using namespace std;

template <class Type>
Type stringToNum(const string& str)
{
    istringstream iss(str);
    Type num;
    iss >> num;
    return num;
}


float*** CreateGrid3(int m,int n,int t);
void FreeGrid3(float*** tt,int m,int n,int t);

int*** CreateGrid3_int(int m,int n,int t);
void FreeGrid3_int(float*** tt,int m,int n,int t);

float*** CreateGrid3_c(int m,int n,int t);
void FreeGrid3_c(float*** p,int m,int n,int t);

float** CreateGrid2_malloc(int m,int n);
void FreeGrid2_malloc(float** tt,int m,int n);

float** CreateGrid2(int m,int n);
void FreeGrid2(float** tt,int m,int n);

int** CreateGrid2_int(int m,int n);
void FreeGrid2_int(int** tt,int m,int n);

float**** CreateGrid4(int m,int n,int t,int w);
void FreeGrid4(float**** tt,int m,int n,int t,int w);

float EuclideanDis(float*a,float*b,int row);
float** TowDimensionDis(float**dis,float**a,int row,int col);

void GridTrans(float **tranData, float *** rawData, int row, int col, int depth);

void QuickSort(float* iArray,int left, int right,int*sortIndex);
void QuickSort_top(float* iArray,int left, int right,int*sortIndex);
void BubbleSort(float  *p, int length, int * ind_diff);
void BubbleSort2(float  *p, int length, int * ind_diff);

void copyData(float*** &data_copy,float*** data,int row,int col,int depth);
//void CreateWholeData(WholeData2 wholeData);
//void FreeWholeData(WholeData2 wholeData);

//row ,col trans,
void dataTrans(float*** &data_trans,float*** data,int row,int col,int depth);

void Standardize_score(float* &data,int row,float cut);

string replaceAWithX(string str,string a,string x);
#endif /* algorithm_h */
