/******************************************************************
 * Copyright (c) 2021
 * All rights reserved.
 
 * Filename: main.cpp
 
 * Version: 1.0
 * Author: Yang Zhang  (zhangyang@big.ac.cn)
 * Date: December, 2021
 
 ******************************************************************/

#include "procedure.h"



int N;//sampleNum
int M;//geneNum
string* input_filename;
string output_filename;
double p_value=1;
int td_sampleN=0;
int td_featureN=0;
float fcm_m_value=0;
string out_runlog;
string out_importance;
clock_t t_start;
clock_t t_end;
int gene_select=1;

int main(int argc, const char * argv[]) {




    int dataTypeNum=0;
    input_filename = new string[20];
    int fileType = -1;
    string label_filename = "";
    string clinicalN_filename = "";
    bool laber;
    int k = 0;
    int tensorDe = 1;

    output_filename = "";
    

    /************************************************************************/
    parseParameter(dataTypeNum, input_filename, output_filename, fileType, label_filename,k,p_value,tensorDe,td_sampleN,td_featureN,fcm_m_value,gene_select, argc, argv);
    if (label_filename == "") {
        laber=0;
    }
    else
        laber = 1;

    /************************************************************

    
    dataTypeNum=2;
    k=4;
    laber = 0;
//
//  fileType = 0;
//    input_filename[0]="/Users/zhangyang/Desktop/MIA/text/wdbc.data/缺失值/wdbc.data.txt";
//     label_filename="/Users/zhangyang/Desktop/MIA/data_2020/wdbc/type.txt";
//    input_filename[0]="/Users/zhangyang/Desktop/fuzzy_c_means_cluster_results.txt";
//input_filename[0]="/Users/zhangyang/Desktop/MIA/data_2020/iris/iris.data.txt";
//label_filename="/Users/zhangyang/Desktop/MIA/data_2020/iris/iris.txt";
//    input_filename[0]="/Users/zhangyang/Desktop/MIA/data_2020/wdbc/监督/2021-11-26/wdbc.random.txt";
//    label_filename="/Users/zhangyang/Desktop/MIA/data_2020/wdbc/监督/2021-11-26/type.txt";
//
    
    fileType = 1;//1:row is gene，0：col is sample
//      input_filename[0]="/Users/zhangyang/Desktop/MIA/data_2020/glioma/CGGA/Me.txt";
//    input_filename[1]="/Users/zhangyang/Desktop/MIA/data_2020/glioma/CGGA/Ex.txt";
//    label_filename="/Users/zhangyang/Desktop/MIA/data_2020/glioma/CGGA/grade.txt";
    
//    input_filename[0]="/Users/zhangyang/Desktop/CGGA/tree1/Me_orderByImportance.txt";
//    input_filename[1]="/Users/zhangyang/Desktop/CGGA/tree1/Ex_orderByImportance.txt";


//    input_filename[0]="/Users/zhangyang/Desktop/MIA/data_2022/TCGA/glioma/P/cnv.txt";
//    input_filename[1]="/Users/zhangyang/Desktop/MIA/data_2022/TCGA/glioma/P/ex.txt";
//    input_filename[2]="/Users/zhangyang/Desktop/MIA/data_2022/TCGA/glioma/P/me.txt";
//    label_filename="/Users/zhangyang/Desktop/MIA/data_2022/TCGA/glioma/type.txt";


//    input_filename[0]="/Users/zhangyang/Desktop/code/MIAdata/data/GTEx_13_regionstxt.txt";

//    input_filename[0]="/Users/zhangyang/Desktop/MIA/data_2022/knockdown/GSE174361.txt";
//    label_filename="/Users/zhangyang/Desktop/MIA/data_2022/knockdown/GSE174361_label.txt";
//
    input_filename[0]="/Users/zhangyang/Desktop/MIA/sim/k=4/n=500m=1000+1000/0/numeric_data_file_0.tsv";
    input_filename[1]="/Users/zhangyang/Desktop/MIA/sim/k=4/n=500m=1000+1000/0/numeric_data_file_1.tsv";

//    label_filename="/Users/zhangyang/Desktop/MIA/sim/k=5/n=500|m=1000+1000/0/label.txt";
    
    
    output_filename="/Users/zhangyang/Desktop/";

    
   ************************* running ***********************************/
    
    if(fileType == -1){          
        fileType = 1;
    }
    //file type
    
    int fileSuffix = fileSuffixType(input_filename,dataTypeNum,label_filename);
    
    if (fileSuffix==0) {
        cout<<"Input parameter(s) error."<<endl;
        cout<<"For help information: *************** -h"<<endl;
        exit(0);
    }
    
//    vector<string> o = split(output_filename, "/");
//    if(o[o.size()-1]!=""){
//        output_filename=output_filename+"/";
//    }
    if ((output_filename.at(output_filename.size()-1))!='/') {
        output_filename=output_filename+"/";
    }
    
    
    out_runlog = output_filename + "runtime_log.txt";
   
    ofstream outfile_log(out_runlog.c_str(),ios::out);
    if(!outfile_log.is_open ()){
        string command;
        command = "mkdir -p " + output_filename;
        system(command.c_str());
//        cout <<"wrong output path, please check your parameters: -O "<<output_filename<<endl;
//        exit(0);
    }
    

    outfile_log<<endl<<"start time: "<<getTime()<<endl<<endl;
    
    t_start=clock();

    
    WholeData wholeData;
  
    if(fileType ==0){
        
        N=CountRow(input_filename[0]);
        M=CountCol(input_filename[0]);
    }
    if (fileType ==1) {
        M=CountRow(input_filename[0]);
        N=CountCol(input_filename[0]);
    }
    wholeData.sampleName=new string[N];
    wholeData.geneName=new string[M];
    wholeData.geneNullsign=new int[M];
    for (int i=0; i<M; ++i) {
        wholeData.geneNullsign[i]=0;
    }
    wholeData.Data=CreateGrid3(N,M,W);
    
  
    
    if(wholeData.rawData!=NULL){
        wholeData.rawData = NULL;
    }
    wholeData.rawData=CreateGrid3(N,M,W);

    wholeData.labelType=new string[N];
    wholeData.sample_label=new string[N];
    
    
    
//    int* geneNullsign = new int[M];
    if(fileType ==0){
        
        
       DataRead0(wholeData,dataTypeNum, input_filename);
    }
    if(fileType ==1){
        DataRead1(wholeData,dataTypeNum, input_filename);
    }
    
    outfile_log<<endl<<"input parameters:"<<endl<<endl;

    
    for (int j=0; j<dataTypeNum; j++) {
        vector<string> v = split(input_filename[j], "/");
//        vector<string> s = split(v[v.size()-1], ".");
        outfile_log<<"Input dataset"<<" "<<j+1<<": "<<v[v.size()-1]<<endl;
    }
    
    if (laber) {
        vector<string> v = split(label_filename, "/");
        outfile_log<<"Sample label: "<<v[v.size()-1]<<endl;
    }
     
    outfile_log<<"sample number: "<<wholeData.sampleNum<<endl<<"feature number: "<<wholeData.geneNum<<endl<<"data type number: "<<wholeData.typeNum<<endl;
    
    outfile_log.close();
    
    cout<<"sample number: "<<wholeData.sampleNum<<endl<<"feature number: "<<wholeData.geneNum<<endl<<"data type number: "<<wholeData.typeNum<<endl;
    
    copyData(wholeData.rawData, wholeData.Data, wholeData.sampleNum, wholeData.geneNum, wholeData.typeNum);
    
    Reduction* reduction_0=new Reduction();
    reduction_0->Run_Variance(wholeData,0);
    for (int i=0; i<wholeData.geneNum; ++i) {
        if(reduction_0->indexReduction_var[i]==1){
            wholeData.geneNullsign[i]=1;
        }
    }
    wholeData.geneNullNum = reduction_0->Reduction_varNum;

    delete reduction_0;

    setbuf(stdout,NULL);//must add when debug
//    tensor_de(wholeData);

    if(dataTypeNum==1){
        tensorDe=0;
    }

    if (!laber) {
        if (k==0) {
            NoLaber(wholeData, dataTypeNum,tensorDe);
        }
        else
            NoLaber_k(wholeData, dataTypeNum,k,tensorDe);
    }
    if (laber) {
        Laber(wholeData, dataTypeNum,label_filename);
    
    }
    
    /************************* release ***********************************/
    if (wholeData.sampleName!=NULL) {
        delete []wholeData.sampleName;
//        free(wholeData.sampleName);
        wholeData.sampleName=NULL;
    }
    if (wholeData.geneName!=NULL) {
        delete []wholeData.sampleName;

        wholeData.geneName=NULL;
    }
    if (wholeData.geneNullsign!=NULL) {
        delete []wholeData.geneNullsign;
        wholeData.geneNullsign=NULL;
    }
    if (wholeData.Data!=NULL) {
    FreeGrid3(wholeData.Data, N,M,W);
    wholeData.Data = NULL;
    }
    if (wholeData.rawData!=NULL) {
    FreeGrid3(wholeData.rawData, N,M,W);
    wholeData.rawData = NULL;
    }
    if (wholeData.labelType!=NULL) {
        delete []wholeData.labelType;
        wholeData.labelType=NULL;
    }
    if (wholeData.sample_label!=NULL) {
        delete []wholeData.sample_label;
        wholeData.sample_label=NULL;
    }


    delete []input_filename;
    input_filename=NULL;
    
    return 0;
}
