/******************************************************************
 * Copyright (c) 2021
 * All rights reserved.
 
 * Filename: procedure.h
 
 * Version: 1.0
 * Author: Yang Zhang  (zhangyang@big.ac.cn)
 * Date: December, 2021
 
 ******************************************************************/

#ifndef procedure_h
#define procedure_h


#include "base.h"
#include "tensor.h"
#include "reduction.h"
#include "fcm.h"
#include "RandomForest.h"
#include "featureSelect.h"
#include <string.h>
#include <random>
#include <iomanip>
//#include <stdlib.h>

//#include "ALGLIB/stdafx.h"
//#include "ALGLIB/ap.h"
//#include "ALGLIB/statistics.h"
//using namespace alglib;



void randomforeastProsse(RandomForest* &randomForest, float* &importance_mean,float**trainset,int classNum,float* cluster,int trainSampleNum,WholeData wholeData,int ReductionNum,int * ReductionIndex);
void splict_train_test(float** &trainset_new,float* &trainlabels,float**  &testset,float*  &testlabels,int TEST_NUM,int sampleNum,float**trainset,float* cluster,int classNum);
void randomforeastProsse_test(RandomForest* &randomForest, float* &importance_mean,float**trainset,int classNum,float* cluster,int trainSampleNum,WholeData wholeData,int ReductionNum,int * ReductionIndex,float**testset,float*testlabels,int TEST_NUM);

void NoLaber(WholeData wholeData, int typenum,int tensorDe);
void NoLaber_k(WholeData wholeData, int typenum,int k,int tensorDe);
void Laber(WholeData wholeData, int typenum, string label_filename);

void label_process(WholeData wholeData,int* ReductionIndex,int ReductionNum,float*cluster,int classNum,float**trainset);

void cluster_label(string* &label,string* &labelType, float* cluster, int sampleNum,int k);
void fcm_out(WholeData wholeData,FCM* fcm,int k);
void fcm_out_noK(WholeData wholeData,FCM* fcm);
void feature_importance_out2( float *score,float cut,RandomForest *randomForest,WholeData wholeData,int classNum,int* geneFeatureImport_Index,float*importance_mean,float*cluster,int * ReductionIndex,int ReductionN);

void runlog_out(WholeData wholeData,int classNum,bool fcm);


#endif /* procedure_h */
