/******************************************************************
 * Copyright (c) 2021
 * All rights reserved.
 
 * Filename: reduction.cpp
 
 * Version: 1.0
 * Author: Yang Zhang  (zhangyang@big.ac.cn)
 * Date: December, 2021
 
 ******************************************************************/

#include "reduction.h"
#include <algorithm>
//#include "output.h"

Reduction::Reduction(){
    Reduction_varNum=0;
    indexReduction_var= new int[M];
    meanValue=NULL;
    varData=NULL;
    varWholeData=NULL;
    varSort_index=NULL;
    varSort_tensor=NULL;
    
}
Reduction::~Reduction(){
    if (indexReduction_var!=NULL) {
        delete []indexReduction_var;
        indexReduction_var=NULL;
    }
    meanValue=NULL;
    indexReduction_var=NULL;
    varData=NULL;
    varWholeData=NULL;
    varSort_index=NULL;
    varSort_tensor=NULL;
    
}





void Reduction:: Variance_tensor(float*** data,int row,int col,int depth,int*geneNullInedx){
    
    for (int j=0; j<col; ++j) {
        if (geneNullInedx[j]==1) {
            varWholeData[j]=0;
        }
        else{
            float squaresNum=0;
            for (int i=0; i<row; ++i) {
                for (int k=0; k<depth; k++) {
                    squaresNum+=(data[i][j][k]-meanValue[j][k])*(data[i][j][k]-meanValue[j][k]);
                }
                
            }
            varWholeData[j]=squaresNum/row;
        }
        
    }
    
}

void Reduction:: Reduction_Variance_tensor_ratio(int row,int col,int geneNullNum,int*geneNullInedx){
    for (int i=0; i<row; ++i) {
        indexReduction_var[i]=0;
    }
    BubbleSort(varWholeData, row, varSort_tensor);
    //varSort_tensor < var_ratio，signReduction_var=1
    int sign_varNum=(row-geneNullNum)*var_ratio + geneNullNum;
    for (int i=0; Reduction_varNum<sign_varNum; ++i) {
       
            indexReduction_var[varSort_tensor[i]]=1;
            Reduction_varNum++;

    }

}

void Reduction:: Reduction_Variance_tensor_threshold(int row,int col,int geneNullNum,int*geneNullInedx){
    for (int i=0; i<row; ++i) {
        indexReduction_var[i]=0;
    }
    BubbleSort(varWholeData, row, varSort_tensor);
    //threshold，signReduction_var=1
    
    for (int i=0; i<row; ++i) {
        if (varWholeData[i]<=var_threshold) {
            indexReduction_var[varSort_tensor[i]]=1;
            Reduction_varNum++;
        }
        else{
            break;
        }
        
    }
    
}



void Reduction:: Variance(float*** data,int row,int col,int depth){
    for (int k=0; k<depth; k++) {
        for (int j=0; j<col; ++j) {
            float squaresNum=0;
            for (int i=0; i<row; ++i) {
                squaresNum+=(data[i][j][k]-meanValue[j][k])*(data[i][j][k]-meanValue[j][k]);
            }
            varData[j][k]=squaresNum/row;
        }
    }
    
}
//n*1 t()
void Reduction:: TranspositionN_1(float* &transData,float **data,int row,int colNum){
    for (int i=0; i<row; ++i) {transData[i]=data[i][colNum];}
}
//n*1 int t()
void Reduction:: TranspositionN_1_int(int* &transData,int **data,int row,int colNum){
    for (int i=0; i<row; ++i) {transData[i]=data[i][colNum];}
    
}
//n*m t()
void Reduction:: TranspositionN_M(int** &transData,int **data,int row,int col){
    for (int j=0; j<col; ++j) {TranspositionN_1_int(transData[j],data, row, j);}
    
}

//two tensor col rank
void Reduction:: SortArray(float**data,int row,int col){
    int **sortIndex=CreateGrid2_int(col, row);
    for (int i=0; i<col; ++i) {
        for (int j=0; j<row; ++j) {sortIndex[i][j]=j;}
    }
    float* transData=new float[row];
    for (int j=0; j<col; ++j) {
        TranspositionN_1(transData,data, row, j);
        QuickSort(transData, 0, row-1, sortIndex[j]);
    }
    TranspositionN_M(varSort_index,sortIndex, col, row);
    FreeGrid2_int(sortIndex, col, row);
    sortIndex=NULL;
}

//Variance Reduction
void Reduction:: Reduction_Variance(int row,int col){
    for (int i=0; i<row; ++i) {
        for (int j=0; j<col; ++j) {signReduction_var[i][j]=0;}
    }
    //找出varSort_index前20%，置signReduction_var为1
    int sign_varNum=row*var_ratio;
    for (int j=0; j<col; ++j) {
        for (int i=0; i<sign_varNum; ++i) {signReduction_var[varSort_index[i][j]][j]=1;}
    }
    
    for (int i=0; i<row; ++i) {
        indexReduction_var[i]=0;
    }
    
    for(int i=0;i<row;i++){
        int t=0;
        for (int j=0; j<col; ++j) {
            if (signReduction_var[i][j]==1) {t++;}//step：a gene >20% in every types
            if (t==col) {
                Reduction_varNum++;
                indexReduction_var[i]=1;
                
            }
        }
    }
}

void Reduction::Run_Variance(WholeData wholeData,int reduction_ratio){
    meanValue=CreateGrid2(wholeData.geneNum, wholeData.typeNum);
//    Standardize(wholeData.Data, wholeData.sampleNum, wholeData.geneNum, wholeData.typeNum);
    
    if(reduction_type==0){
         //Reduction in tensor
        if(reduction_ratio==1){
            varWholeData=new float[wholeData.geneNum];
            varSort_tensor=new int[wholeData.geneNum];
            Variance_tensor(wholeData.Data, wholeData.sampleNum, wholeData.geneNum, wholeData.typeNum,wholeData.geneNullsign);
            
            Reduction_Variance_tensor_ratio(wholeData.geneNum, wholeData.typeNum,wholeData.geneNullNum,wholeData.geneNullsign);
            
            
            
            if (varWholeData!=NULL) {
                delete []varWholeData;
                varWholeData=NULL;
            }
            if (varSort_tensor!=NULL) {
                delete []varSort_tensor;
                varSort_tensor=NULL;
            }
        }
        else{
            varWholeData=new float[wholeData.geneNum];
            varSort_tensor=new int[wholeData.geneNum];
            Variance_tensor(wholeData.Data, wholeData.sampleNum, wholeData.geneNum, wholeData.typeNum,wholeData.geneNullsign);
            
            Reduction_Variance_tensor_threshold(wholeData.geneNum, wholeData.typeNum,wholeData.geneNullNum,wholeData.geneNullsign);
            
            
            
            if (varWholeData!=NULL) {
                delete []varWholeData;
                varWholeData=NULL;
            }
            if (varSort_tensor!=NULL) {
                delete []varSort_tensor;
                varSort_tensor=NULL;
            }
        }
       
       
    }
    
    //Reduction in types then converge
    if (reduction_type==1) {
        
        varData=CreateGrid2(wholeData.geneNum, wholeData.typeNum);
        varSort_index=CreateGrid2_int(wholeData.geneNum, wholeData.typeNum);
        signReduction_var=CreateGrid2_int(wholeData.geneNum, wholeData.typeNum);
        
        Variance(wholeData.Data, wholeData.sampleNum, wholeData.geneNum, wholeData.typeNum);
        SortArray(varData, wholeData.geneNum, wholeData.typeNum);
        Reduction_Variance(wholeData.geneNum, wholeData.typeNum);
        FreeGrid2(varData, wholeData.geneNum, wholeData.typeNum);
        varData=NULL;
        FreeGrid2_int(varSort_index, wholeData.geneNum, wholeData.typeNum);
        varSort_index=NULL;
        FreeGrid2_int(signReduction_var, wholeData.geneNum, wholeData.typeNum);
        signReduction_var=NULL;
    }
  
    FreeGrid2(meanValue, wholeData.geneNum, wholeData.typeNum);
    meanValue=NULL;
    
    
    
}
