/******************************************************************
 * Copyright (c) 2021
 * All rights reserved.
 
 * Filename: reduction.h
 
 * Version: 1.0
 * Author: Yang Zhang  (zhangyang@big.ac.cn)
 * Date: December, 2021
 
 ******************************************************************/

#ifndef reduction_h
#define reduction_h
#include <stdio.h>
#include "base.h"

/*****Global variables*****/
//extern int N;
//extern int M;

class Reduction{
    
public:
    int reduction_type=0;//Reduction type
    int *indexReduction_var;//Reduction sign
    int Reduction_varNum;//Reduction number
private:
    int **signReduction_var; //Variance mark, initially 0, when it is 1, the variance of a certain set of academic data of the gene is less than the var_ratio ratio
    float** meanValue;//column mean
    float** varData;//column variance
    float* varWholeData;//the variance of the vector column, and then sort it
    
    int** varSort_index;//the column index after sorting the variance
    int* varSort_tensor;//the column index after sorting the variance
    
    float var_ratio=0.3;
    float var_threshold=0;
    
public:
    
    Reduction();
    ~Reduction();

    //Calculate column variance
    void Variance(float*** data,int row,int col,int depth);
    void Variance_tensor(float*** data,int row,int col,int depth,int*geneNullInedx);
    //n*1 t()
    void TranspositionN_1(float* &transData,float **data,int row,int colNum);
    //n*1 int t()
    void TranspositionN_1_int(int* &transData,int **data,int row,int colNum);
    //n*m t()
    void TranspositionN_M(int** &transData,int **data,int row,int col);
    
    //Sorting of two-dimensional array columns
    void SortArray(float**data,int row,int col);
    //Dimensionality reduction by variance
    void Reduction_Variance(int row,int col);
    void Reduction_Variance_tensor_ratio(int row,int col,int geneNullNum,int*geneNullInedx);
    void Reduction_Variance_tensor_threshold(int row,int col,int geneNullNum,int*geneNullInedx);

    //main function
    void Run_Variance(WholeData wholeData,int reduction_ratio);
    
    
};




#endif /* reduction_h */
