/******************************************************************
 * Copyright (c) 2021
 * All rights reserved.
 
 * Filename: base.cpp
 
 * Version: 1.0
 * Author: Yang Zhang  (zhangyang@big.ac.cn)
 * Date: December, 2021
 
 ******************************************************************/
#include "base.h"


string getTime()
{
    time_t timep;
    time (&timep);
    char tmp[64];
    strftime(tmp, sizeof(tmp), "%Y-%m-%d %H:%M:%S",localtime(&timep) );
    return tmp;
}

vector<string> split(const string &s, const string &seperator){
    vector<string> result;
    typedef string::size_type string_size;
    string_size i = 0;
    
    while(i != s.size()){
       
        int flag = 0;
        while(i != s.size() && flag == 0){
            flag = 1;
            for(string_size x = 0; x < seperator.size(); ++x)
                if(s[i] == seperator[x]){
                    ++i;
                    flag = 0;
                    break;
                }
        }
        
       
        flag = 0;
        string_size j = i;
        while(j != s.size() && flag == 0){
            for(string_size x = 0; x < seperator.size(); ++x)
                if(s[j] == seperator[x]){
                    flag = 1;
                     break;
                }
            if(flag == 0)
                ++j;
        }
        if(i != j){
            result.push_back(s.substr(i, j-i));
            i = j;
        }
    }
    return result;
}

string stringtoUpper(string str) {
    int j;
    for(j=0; j<str.length(); ++j){str[j] = toupper(str[j]);}
    return str;
}



int CountRow(string filename){
    ifstream infile;

    
    int N=0;
    
    infile.open(filename,ios::in);
    
    if(!infile.is_open ()){
         ofstream outfile_runlog(out_runlog.c_str(),ios::app);
        cout << "Open\""<<filename<<"\" failure" << endl;
        outfile_runlog<< "Open\""<<filename<<"\" failure" << endl;
        outfile_runlog.close();
        exit(0);
    }
    string str;
    while (!infile.eof()){
        
        getline(infile,str);
        N++;
        
    }
    infile.close();
    
    if (N==0) {
        ofstream outfile_runlog(out_runlog.c_str(),ios::app);
        cout <<"ERROR"<<endl;
        cout <<"the number of row is 0." << endl;
        outfile_runlog<<"the number of row is 0." << endl;
        outfile_runlog.close();
        exit(0);
    }
    return N+5;
}
int CountCol(string filename){
    ifstream infile;

    int M=0;
    
    
    infile.open(filename,ios::in);
    
    if(!infile.is_open ()){
        cout <<"ERROR"<<endl;
        
        cout << "Open\""<<filename<<"\" failure" << endl;
        ofstream outfile_runlog(out_runlog.c_str(),ios::app);
        outfile_runlog<< "Open\""<<filename<<"\" failure" << endl;
        outfile_runlog.close();
        exit(0);
    }
    string str,s,t;
    getline(infile,str);
//    for(istringstream sin(str);sin>>t;){M++;}
    
   
    istringstream iss(str);
    
    string buffer;
    while(getline(iss, buffer, '\t'))
    {
//        cout<<buffer<<endl;
        M++;
    }

    infile.close();
    
    if (M==0) {
        cout <<"ERROR"<<endl;
        ofstream outfile_runlog(out_runlog.c_str(),ios::app);
        cout <<"the number of col is 0." << endl;
        outfile_runlog<<"the number of col is 0." << endl;
        outfile_runlog.close();
        exit(0);
    }
    
    return M+5;
}



void DataRead0(WholeData &WholeData,int typenum,string* filename){
    WholeData.typeNum=typenum;
    for (int i=0; i<M; ++i) {
        WholeData.geneNullsign[i]=0;
    }

    for (int i=0;i<typenum;i++) {
        
        ifstream infile;
        
        infile.open(filename[i],ios::in);
        
        if(!infile.is_open ()){
            ofstream outfile_runlog(out_runlog.c_str(),ios::app);
            cout << "Open\""<<filename[i]<<"\" failure" << endl;
            outfile_runlog<< "Open\""<<filename[i]<<"\" failure" << endl;
            outfile_runlog.close();
            exit(0);
        }
        string str;
        
       
        //read gene
        //cin.ignore();
        getline(infile,str);
        str=replaceAWithX(str, "\n", "");
        str=replaceAWithX(str, "\r", "");
        
     
        string t;
        int n = 0;
        
        if (i==0) {
            
            istringstream iss(str);
            
            getline(iss, t, '\t');
            
            while(getline(iss, t, '\t'))
            {
                 WholeData.geneName[n++]=(string)t;
                
            }
           
            
//            istringstream sin(str);
//            //for(istringstream sin(str); sin>>t;) {
//            while (sin>>t) {
//                WholeData.geneName[n++]=(string)t;
//
//            }
             WholeData.geneNum=n;
        }
        else{
            int ns=0;
            
            istringstream isss(str);
            
            
            string tt;
            getline(isss, tt, '\n');
            getline(isss, tt, '\r');
            istringstream iss(tt);
            
            getline(iss, t, '\t');
            
            while(getline(iss, t, '\t'))
            {
                if(stringtoUpper(WholeData.geneName[ns])!=stringtoUpper(t)){
                    cout <<"ERROR"<<endl;
                    ofstream outfile_runlog(out_runlog.c_str(),ios::app);
                    cout <<"the "<<ns+1<<"th"<<" feature name is different with other(s) data."<< endl;
                    outfile_runlog<<"the "<<ns+1<<"th"<<" feature name is different with other(s) data."<< endl;
                    outfile_runlog.close();
                    exit(0);
                }
                ns++;
                
            }
            
//            istringstream sin(str);
//            while (sin>>t) {
//                if(stringtoUpper(WholeData.geneName[ns])!=stringtoUpper(t)){
//                    cout <<"ERROR"<<endl;
//                    ofstream outfile_runlog(out_runlog.c_str(),ios::app);
//                    cout <<"the "<<ns+1<<"th"<<" feature name is different with other(s) data."<< endl;
//                    outfile_runlog<<"the "<<ns+1<<"th"<<" feature name is different with other(s) data."<< endl;
//                    outfile_runlog.close();
//                    exit(0);
//                }
//                ns++;
//
//            }
        }
        
       
        int u = 0;//sample
        string v;//gene
        
        string w;
        
        //read sample
        while (!infile.eof()){
            int a= 0;
            
            getline(infile,str);
            str=replaceAWithX(str, "\n", "");
            str=replaceAWithX(str, "\r", "");
            
//            infile>>w;
//
//            if (i==0) {
//                WholeData.sampleName[u]=(string)w;
//            }
//            else{
//                if (stringtoUpper(WholeData.sampleName[u])!=stringtoUpper(w)) {
//                    cout <<"ERROR"<<endl;
//                    ofstream outfile_runlog(out_runlog.c_str(),ios::app);
//                    cout <<"the "<<u+1<<"th"<<" sample name is different with other(s) data."<< endl;
//                    outfile_runlog<<"the "<<u+1<<"th"<<" sample name is different with other(s) data."<< endl;
//                    outfile_runlog.close();
//                    exit(0);
//                }
//            }
            
            istringstream iss(str);
            
            getline(iss, w, '\t');
            if (i==0) {
                WholeData.sampleName[u]=(string)w;
            }
            else{
                if (stringtoUpper(WholeData.sampleName[u])!=stringtoUpper(w)) {
                    cout <<"ERROR"<<endl;
                    ofstream outfile_runlog(out_runlog.c_str(),ios::app);
                    cout <<"the "<<u+1<<"th"<<" sample name is different with other(s) data."<< endl;
                    outfile_runlog<<"the "<<u+1<<"th"<<" sample name is different with other(s) data."<< endl;
                    outfile_runlog.close();
                    exit(0);
                }
            }
            
            
            while(getline(iss, v, '\t'))
            {
                if (WholeData.geneNum!=0 && a>WholeData.geneNum) {
                    cout <<"ERROR"<<endl;
                    ofstream outfile_runlog(out_runlog.c_str(),ios::app);
                    cout << "The number of columns is not uniform" << endl;
                    outfile_runlog<< "The number of columns is not uniform" << endl;
                    outfile_runlog.close();
                    exit(0);
                }
                if (v =="undefine" || v =="na" || v =="NA" || v =="NULL" || v =="null" || v =="" ) {
                    if (WholeData.geneNullsign[a]!=1) {
                        WholeData.geneNullsign[a]=1;
                        WholeData.geneNullNum++;
                    }
                    WholeData.Data[u][a][i]=0;
                }
                else{
                    
                    WholeData.Data[u][a][i]=stringToNum<float>(v);//atof(v.c_str() );
                }
                a++;
                
            }
            
//            for(istringstream sin(str); sin>>v;a++)
//            {
//                if (WholeData.geneNum!=0 && a>WholeData.geneNum) {
//                    cout <<"ERROR"<<endl;
//                    ofstream outfile_runlog(out_runlog.c_str(),ios::app);
//                    cout << "The number of columns is not uniform" << endl;
//                    outfile_runlog<< "The number of columns is not uniform" << endl;
//                    outfile_runlog.close();
//                    exit(0);
//                }
//                if (v =="undefine" || v =="na" || v =="NA" || v =="NULL" || v =="null" || v =="" ) {
//                    if (WholeData.geneNullsign[a]!=1) {
//                        WholeData.geneNullsign[a]=1;
//                        WholeData.geneNullNum++;
//                    }
//                    WholeData.Data[u][a][i]=0;
//                }
//                else{
//
//                    WholeData.Data[u][a][i]=stringToNum<float>(v);//atof(v.c_str() );
//                }
//             }
            if (u>N) {
                cout <<"ERROR"<<endl;
                ofstream outfile_runlog(out_runlog.c_str(),ios::app);
                cout << "The number of rows is not uniform" << endl;
                outfile_runlog<< "The number of rows is not uniform" << endl;
                outfile_runlog.close();
                exit(0);
            }
            u=u+1;

            
        }
        
        
        if (i==0) {
//            WholeData.geneNum=n;
            WholeData.sampleNum=u;
        }
        else{
            if (WholeData.sampleNum!=u) {
                cout <<"ERROR"<<endl;
                ofstream outfile_runlog(out_runlog.c_str(),ios::app);
                cout << "The number of rows is not uniform" << endl;
                outfile_runlog<< "The number of rows is not uniform" << endl;
                outfile_runlog.close();
                exit(0);
            }
        }
        infile.close();
    }
    
//    return WholeData;
}
void DataRead1(WholeData &WholeData,int typenum,string* filename){
    WholeData.typeNum=typenum;

    for (int i=0;i<typenum;i++) {
        
        ifstream infile;
        
        infile.open(filename[i],ios::in);
        
        if(!infile.is_open ()){
           cout << "Open\""<<filename[i]<<"\" failure" << endl;
            exit(0);
        }
        string str;
//        char ch;
//        //streampos sp=infile.tellg();
//        infile.get(ch);
//        if (ch!='\t') {
//            infile>>s;
//        }
        //read gene
        //cin.ignore();
        getline(infile,str);
        
        str=replaceAWithX(str, "\n", "");
        str=replaceAWithX(str, "\r", "");
        
        string t;
        int n = 0;
        
        if (i==0) {
            
           
           istringstream iss(str);
            
            getline(iss, t, '\t');
            
            while(getline(iss, t, '\t'))
            {
               
                 WholeData.sampleName[n++]=(string)t;
                
            }
             WholeData.sampleNum=n;
        }
   
//        string t;
//        int n = 0;
//
//        if (i==0) {
//
//
//            istringstream sin(str);
//            while (sin>>t) {
//                WholeData.sampleName[n++]=(string)t;
//            }
//            WholeData.sampleNum=n;
//        }
        else{
             int ns=0;
            istringstream isss(str);
            
            
            string tt;
            getline(isss, tt, '\n');
            getline(isss, tt, '\r');
            istringstream iss(tt);
            
            getline(iss, t, '\t');
            
            while(getline(iss, t, '\t'))
            {
                if(stringtoUpper(WholeData.sampleName[ns])!=stringtoUpper(t)){
                    cout <<"ERROR"<<endl;
                    ofstream outfile_runlog(out_runlog.c_str(),ios::app);
                    cout <<"the "<<ns+1<<"th"<<" sample name is different with other(s) data."<< endl;
                    outfile_runlog<<"the "<<ns+1<<"th"<<" sample name is different with other(s) data."<< endl;
                    outfile_runlog.close();
                    exit(0);
                }
                ns++;
            }
            
           
//            istringstream sin(str);
//            while (sin>>t) {
//                if(stringtoUpper(WholeData.sampleName[ns])!=stringtoUpper(t)){
//                    cout <<"ERROR"<<endl;
//                    ofstream outfile_runlog(out_runlog.c_str(),ios::app);
//                    cout <<"the "<<ns+1<<"th"<<" sample name is different with other(s) data."<< endl;
//                    outfile_runlog<<"the "<<ns+1<<"th"<<" sample name is different with other(s) data."<< endl;
//                    outfile_runlog.close();
//                    exit(0);
//                }
//                ns++;
//
//            }
        }
        int u = 0;
        string v;
        string w;
        
        //read sample
        while (!infile.eof()){
            int a= 0;
//            infile>>w;
//
//            //WholeData.sampleData[u].sample = w;
//            if (i==0) {
//                WholeData.geneName[u]=w;
//            }
//            else{
//                if (stringtoUpper(WholeData.geneName[u])!=stringtoUpper(w)) {
//                    cout <<"ERROR"<<endl;
//                    ofstream outfile_runlog(out_runlog.c_str(),ios::app);
//                    cout <<"the "<<u+1<<"th"<<" feature name is different with other(s) data."<< endl;
//                    outfile_runlog<<"the "<<u+1<<"th"<<" feature name is different with other(s) data."<< endl;
//                    outfile_runlog.close();
//                    exit(0);
//                }
//            }
            
            
            getline(infile,str);
            str=replaceAWithX(str, "\n", "");
            str=replaceAWithX(str, "\r", "");
            
            istringstream iss(str);
            
            getline(iss, w, '\t');
            if (i==0) {
                WholeData.geneName[u]=w;
            }
            else{
                if (stringtoUpper(WholeData.geneName[u])!=stringtoUpper(w)) {
                    cout <<"ERROR"<<endl;
                    ofstream outfile_runlog(out_runlog.c_str(),ios::app);
                    cout <<"the "<<u+1<<"th"<<" feature name is different with other(s) data."<< endl;
                    outfile_runlog<<"the "<<u+1<<"th"<<" feature name is different with other(s) data."<< endl;
                    outfile_runlog.close();
                    exit(0);
                }
            }
            
            
            while(getline(iss, v, '\t'))
            {
                if (WholeData.sampleNum!=0 && a>WholeData.sampleNum) {
                    cout <<"ERROR"<<endl;
                    ofstream outfile_runlog(out_runlog.c_str(),ios::app);
                    cout << "The number of columns is not uniform" << endl;
                    outfile_runlog<< "The number of columns is not uniform" << endl;
                    outfile_runlog.close();
                    exit(0);
                }
                if (v =="undefine" || v =="na" || v =="NA" || v =="NULL" || v =="null" || v =="") {
                    if (WholeData.geneNullsign[u]!=1) {
                        WholeData.geneNullsign[u]=1;
                        WholeData.geneNullNum++;
                    }
                    WholeData.Data[a][u][i]=0;
                    
                }
                else{
                   
                    WholeData.Data[a][u][i]=stringToNum<float>(v);
                    
                    
                }
                a++;
                
            }
            
//            for(istringstream sin(str); sin>>v;a++)
//            {
//
//                if (WholeData.sampleNum!=0 && a>WholeData.sampleNum) {
//                    cout <<"ERROR"<<endl;
//                    ofstream outfile_runlog(out_runlog.c_str(),ios::app);
//                    cout << "The number of columns is not uniform" << endl;
//                    outfile_runlog<< "The number of columns is not uniform" << endl;
//                    outfile_runlog.close();
//                    exit(0);
//                }
//                if (v =="undefine" || v =="na" || v =="NA" || v =="NULL" || v =="null" || v =="") {
//                    if (WholeData.geneNullsign[u]!=1) {
//                        WholeData.geneNullsign[u]=1;
//                        WholeData.geneNullNum++;
//                    }
//                    WholeData.Data[a][u][i]=0;
//
//                }
//                else{
//                    WholeData.Data[a][u][i]=stringToNum<float>(v);
//
//
//                }
//
//            }
            if (u>M) {
                cout <<"ERROR"<<endl;
                ofstream outfile_runlog(out_runlog.c_str(),ios::app);
                cout << "The number of rows is not uniform" << endl;
                outfile_runlog<< "The number of rows is not uniform" << endl;
                outfile_runlog.close();
                exit(0);
            }
            u=u+1;
            //lines++;
            
        }
        
        if (i==0) {
//            WholeData.sampleNum=n;
            WholeData.geneNum=u;
        }
        else{
            if (WholeData.geneNum!=u) {
                cout <<"ERROR"<<endl;
                ofstream outfile_runlog(out_runlog.c_str(),ios::app);
                cout << "The number of rows is not uniform" << endl;
                outfile_runlog<< "The number of rows is not uniform" << endl;
                outfile_runlog.close();
                exit(0);
            }
        }
        infile.close();
    }
//    return WholeData;
}
void ReadLabel(float* &label,int &k,string* &labelType,string* &labelName,int row,string filename,string *sampleName){
    
        ifstream infile;
    
//    string* labelName=new string[N];
   
        infile.open(filename,ios::in);
        
    if(!infile.is_open ()){
            cout << "Open\""<<filename<<"\" failure" << endl;
        exit(0);
    }
        string str,s;
   ofstream outfile_runlog(out_runlog.c_str(),ios::app);
    getline(infile,str);//tittle
    str=replaceAWithX(str, "\n", "");
    str=replaceAWithX(str, "\r", "");
    
    int n=0;
 
    while (!infile.eof()){
        
        getline(infile,str);
        str=replaceAWithX(str, "\n", "");
        str=replaceAWithX(str, "\r", "");
        
        istringstream iss(str);
        
        getline(iss, s, '\t');
        
        
//        infile>>s;
        if (s!=sampleName[n] && n<=row) {
            cout<<s<<endl<<sampleName[n]<<endl;
            cout <<"ERROR"<<endl;
            cout << "The order of labels is unequal to the order of samples! " << endl;
            outfile_runlog<<"The order of labels is unequal to the order of samples! " << endl;
            outfile_runlog.close();
            exit(0);
        }
//        infile>>s;
         getline(iss, s, '\t');
        labelName[n++]=(string)s;
        
    }

    infile.close();
    
//    string* _type=new string[row];
    int typeNum;
    countType(typeNum, labelType, labelName, row);

    for (int i=0; i<row; ++i) {
        for (int j=0; j<typeNum; ++j) {
            if (labelName[i]==labelType[j]) {
                label[i]=(float)j;

            }
        }
    }
    k=typeNum;
   
   
//    delete []labelName;
//    labelName=NULL;
//    delete []_type;
//    _type=NULL;
}

void countType(int &typeNum, string* &_type, string* _label,int row){
   
    for (int i=0; i<row; ++i) {
        _type[i]="na";
    }
    _type[0]=_label[0];
//    _type_f[0]=(float)0;
    typeNum=1;
    
    for (int i=0; i<row; ++i) {
        bool sign=0;
        for (int j=0; j<row; ++j) {
            if (_type[j]=="na") {
                break;
            }
           else if (_label[i]==_type[j]) {
                sign=1;
                break;
           }
        }
        if (!sign) {
           
            _type[typeNum]=_label[i];
//            _type_f[typeNum]=(float)typeNum;
            typeNum++;
            
        }

    }

}

void countType2(int* &label, int* result,int row){
    int * _type=new int[row];
    int typeNum;
    

    
    for (int i=0; i<row; ++i) {
        _type[i]=-1;
    }
    _type[0]=result[0];
    typeNum=1;
    
    for (int i=0; i<row; ++i) {
        bool sign=0;
        for (int j=0; j<row; ++j) {
            if (_type[j]==-1) {
                break;
            }
            else if (result[i]==_type[j]) {
                sign=1;
                break;
            }
        }
        if (!sign) {
            
            _type[typeNum]=result[i];
            typeNum++;
            
        }
        
    }
    for (int i=0; i<row; ++i) {
        for (int j=0; j<typeNum; ++j) {
            if (result[i]==_type[j]) {
                label[i]=(int)j;
               
            }
        }
    }
  
    delete []_type;
    _type=NULL;
   
}



//释放wholedata2结构内存
void FreeWholeData(WholeData wholeData){
    delete []wholeData.sampleName;
    delete []wholeData.geneName;
    int m=wholeData.sampleNum;
    int n=wholeData.geneNum;
    int t=wholeData.typeNum;

    if(wholeData.Data != NULL){
        
        FreeGrid3_c(wholeData.Data, m, n, t);
        wholeData.Data = NULL;
    }
}

///*Standardize two tensor*/
float **Standardize(float **data,int row,int col){
    float **stData=new float*[col];
    for(int i=0;i<row;i++)
        stData[i] = new float[col];
    
    float* a=new float[col];  //col—max
    float* b=new float[col];  //col—min
    float* c=new float[row];  //one col data
    for(int i=0;i<col;i++){
        
        for(int j=0;j<row;j++){c[j]=data[j][i];}
        a[i]=c[0];
        b[i]=c[0];
        for(int j=0;j<row;j++){
            
            if(c[j]>a[i]){a[i]=c[j];}
           
            if(c[j]<b[i]){b[i]=c[j];}
        }
    }
   
    for(int j=0;j<col;j++){
        for(int i=0;i<row;i++){
            if(data[i][j]-b[j]==0){stData[i][j]=0;}
            else{stData[i][j]=(data[i][j]-b[j])/(a[j]-b[j]);}
        }
    }
    delete[]a;a=NULL;
    delete[]b;b=NULL;
    delete[]c;c=NULL;
    return stData;
}

/*Standardize three tensor*/
void Standardize(float*** &data,int row,int col,int depth){
    float* a=new float[col];
    float* b=new float[col];
    float* c=new float[row];
    for (int t=0; t<depth; t++) {
        for(int i=0;i<col;i++){
           
            for(int j=0;j<row;j++){c[j]=data[j][i][t];}
            a[i]=c[0];b[i]=c[0];
            for(int j=0;j<row;j++){
                
                
                if(c[j]>a[i]){a[i]=c[j];}
               
                if(c[j]<b[i]){b[i]=c[j]; }
            }
        }
       
        for(int j=0;j<col;j++){

            for(int i=0;i<row;i++){
                if(data[i][j][t]-b[j]==0){data[i][j][t]=0;}
                else{
                    data[i][j][t]=(data[i][j][t]-b[j])/(a[j]-b[j]);
                }

            }

        }
    }
    
    delete[]a;a=NULL;
    delete[]b;b=NULL;
    delete[]c;c=NULL;
}

void parseParameter(int &typenum,string* &seq_filename,string &output_filename,int &fileType,string &label_filename,int &k,double &p_value,int &tensorDe,int &td_sampleN,int &td_featureN,float &fcm_m_value,int &gene_select,int argc, const char* argv[]){

    string filetype;

    cout<<endl;
    bool flag = true;
    int i;
    string temp;
    
    try {
        
        //No parameter
        if (argc==1) {
            cout<<"Please input arguments."<<endl;
            helpInfo();
           

            exit(0);
            //else for only one parameter - seq_filename
        }
        else if (argc==2) {//help information
            temp=argv[1];
            if(temp=="-H"||temp=="-h") {
                helpInfo();
                flag = false;
                exit(0);
            }
            else {
                
                cout<<"Input arguments error."<<endl;
                helpInfo();
                exit(0);
            }
        }
        else {
            //parse arguments
            int inputflag=0,fileTypeflag = 0, labelflag=0, Kflag=0,outputflag=0,Pflag=0,tdflag=0;
            int td_sflag=0,td_fflag=0;
            int fcm_mflag=0,gene_selectflag=0;
            for (i=1; i<argc; ++i) {
                
                temp = stringtoUpper(argv[i]);
                //Input axt file
                if (temp=="-I") {
                    if ((i+1)<argc) {
                        //                        while (argv[i]=="-t" || argv[i]=="-T") {
                        seq_filename[inputflag] = argv[++i];
                        
                        inputflag++;
                        //                        }
                        
                    }
                    else {
                        
                        cout<<"Input arguments error."<<endl;
                        helpInfo();
                        exit(0);
                    }
                }
                //file type
                else if (temp=="-T") {
                    if ((i+1)<argc && fileTypeflag==0) {
                        filetype = argv[++i];
                        if (stringToNum<int>(filetype) !=0 && stringToNum<int>(filetype) !=1) {
                            
                            cout<<"Input arguments error."<<endl;
                            helpInfo();
                            exit(0);
                        }
                        else{
                            fileType=stringToNum<int>(filetype);
                            fileTypeflag++;
                        }
                    }

                }
                //fcm m
                               else if (temp=="-M") {
                                   if ((i+1)<argc && fcm_mflag==0) {
                                       string fcm_m = argv[++i];
                                       if (stringToNum<float>(fcm_m) <1) {
                                           
                                           cout<<"Input arguments error."<<endl;
                                           helpInfo();
                                           exit(0);
                                       }
                                       else{
                                           fcm_m_value=stringToNum<float>(fcm_m);
                                           fcm_mflag++;
                                       }
                                   }

                               }
                //laber file
                else if (temp=="-L" ) {
                    if ((i+1)<argc && labelflag==0) {
                        
                        label_filename = argv[++i];
                        labelflag++;
                    }
                    else {
                        
                        cout<<"Input arguments error."<<endl;
                        helpInfo();
                        exit(0);
                    }
                }
                //K
                else if (temp=="-K" ) {
                    if ((i+1)<argc && Kflag==0) {
                       string _k = argv[++i];
                        if (stringToNum<int>(_k) <=1) {
                            
                            cout<<"Input arguments error."<<endl;
                            helpInfo();
                            exit(0);
                        }
                        else{
                            k=stringToNum<int>(_k);
                            Kflag++;
                        }
                    }
                }
                //p_value
                else if (temp=="-P" ) {
                    if ((i+1)<argc && Pflag==0) {
                        string _p = argv[++i];
                        if (stringToNum<double>(_p)>1 || stringToNum<double>(_p)<0) {
                            
                            cout<<"Input arguments error."<<endl;
                            helpInfo();
                            exit(0);
                        }
                        else{
                            p_value=stringToNum<double>(_p);
                            Pflag++;
                        }
                    }
                }
                //tensor de
                else if (temp=="-TD" ) {
                    if ((i+1)<argc && tdflag==0) {
                        string _td = argv[++i];
                        if (stringToNum<int>(_td)==0) {
                           tensorDe =0;
                           Pflag++;
                        }
                        else{
                            tensorDe =1;
                            Pflag++;
                        }
                    }
                }
                //gene_select
                               else if (temp=="-GENE_SELECT" ) {
                                   if ((i+1)<argc && gene_selectflag==0) {
                                       string _gene_select = argv[++i];
                                       if (stringToNum<int>(_gene_select)==0) {
                                          gene_select =0;
                                          gene_selectflag++;
                                       }
                                       else{
                                           gene_select =1;
                                           gene_selectflag++;
                                       }
                                   }
                               }
else if (temp=="-TD_SAMPLEN" ) {
                    if ((i+1)<argc && tdflag==0) {
                        string _td_s = argv[++i];
                        if (stringToNum<int>(_td_s)==0 || stringToNum<int>(_td_s)<0) {
                            cout<<"Input arguments error."<<endl;
                            helpInfo();
                            exit(0);
                        }
                        else{
                            td_sampleN=stringToNum<int>(_td_s);
                            td_sflag++;
                        }
                    }
                }
else if (temp=="-TD_FEATUREN" ) {
                    if ((i+1)<argc && tdflag==0) {
                        string _td_f = argv[++i];
                        if (stringToNum<int>(_td_f)==0 || stringToNum<int>(_td_f)<0 ) {
                            cout<<"Input arguments error."<<endl;
                            helpInfo();
                            exit(0);
                        }
                        else{
                            td_featureN=stringToNum<int>(_td_f);
                            td_fflag++;
                        }
                    }
                }

                //Output file
                else if (temp=="-O") {
                    if ((i+1)<argc && outputflag==0) {
                        output_filename = argv[++i];
                        outputflag++;
                    }
                    else {
                        
                        cout<<"Input arguments error."<<endl;
                        helpInfo();
                        exit(0);
                    }
                }
                
                else {
                    
                    cout<<"Input arguments error."<<endl;
                    helpInfo();
                    exit(0);
                }
            }
            
            //If no input or output file, report error
            if(inputflag==0 || outputflag==0){
               
                 cout<<"Input arguments error."<<endl;
                if (inputflag==0) {
                    
                    cout<<"Please input data filename."<<endl;
                    helpInfo();
                }
//                if (fileTypeflag==0) {
//                    cout<<"Please input file type."<<endl;
//                }
                if (outputflag==0) {
                    
                    cout<<"Please input output filename"<<endl;
                }
              helpInfo();
                exit(0);
            }
            typenum=inputflag;
//            cout<<"typenum"<<typenum<<endl;
        }
        
    }
    catch (...) {
        cout<<"Input parameter(s) error."<<endl;
        helpInfo();
        flag = false;
    }
    
//    return flag;
}

int fileSuffixType(string* input_filename,int datatypeNum,string label_filename){
    bool sign=0;
    for (int j=0; j<datatypeNum; ++j) {
        vector<string> v = split(input_filename[j], "/");
       
        vector<string> s = split(v[v.size()-1], ".");
        if (s[s.size()-1]=="txt" || s[s.size()-1]=="tsv") {
            sign = 1;
        }
        else{
            
            cout<<"Unsupported file type: "<<input_filename[j]<<endl;
            cout<<"Please input .txt/.tsv file."<<endl;
            exit(0);
        }
    }
    if (label_filename!="") {
        vector<string> v = split(label_filename, "/");
        //    for(vector<string>::size_type i = 0; i != v.size(); ++i)
        //        cout << v[i] << " ";
        //    cout << endl;
        //        cout<<v[v.size()-1];
        vector<string> s = split(v[v.size()-1], ".");
        if (s[s.size()-1]=="txt" || s[s.size()-1]=="tsv") {
            sign = 1;
        }
        else{
            
            cout<<"Unsupported file type: "<<label_filename<<endl;
            cout<<"Please input .txt/.tsv file."<<endl;
            exit(0);
        }
    }
    
    return sign;
}



float KH(string data,string label){
    float p=0;
//    char* line="R"+'\n'+"";
//    system(line);
    return p;
}


void input(){
    cout<<"input"<<endl;
}
void helpInfo(){
    
    cout<< endl<<"MIA (Multi-omics Integrative Analysis), Version: 1.0 [December 8, 2021]"<<endl;
    cout<<"Function: Clustering integrative multi-omics data (Fuzzy C-Means algorithm) and prioritizing genes by considering their contributions to the clustering or labels (Random Forest algorithm)."<<endl;
    cout<<"Usage: MIA [arguments]"<<endl<<endl;
    
    cout<<"Arguments: "<<endl;
    cout<<'\t'<<"-i"<<'\t'<<"Input omics data file name [string, required]. Over two omics please repeat this process."<<endl;
    cout<<'\t'<<"-o"<<'\t'<< "Output folder name [string, required]."<<endl;
    cout<<'\t'<<"-l"<<'\t'<< "Input sample labels file name [string, optional]. If you would like to analyze the unlabeled samples, just ignore this argument."<<endl;
    cout<<'\t'<<"-k"<<'\t'<< "Cluster number [integer, optional]. If you would like to automatically calculate the best k value, just ignore this argument."<<endl;
//    cout<<'\t'<<"-td"<<'\t'<< "Tensor decomposition [integer, optional]. If you would like to automatically calculate the best k value, just ignore this argument."<<endl;
       cout<<'\t'<<"-m"<<'\t'<< "the fuzzy index m [float, optional] of fuzzy C-means clustering. When feature number>8, default m=1+(1418/M+22.05)N^(-2)+(12.33/M+0.243)N^(-0.0406ln(M)-0.1134),  where N represents the number of samples and M represents the number of features. When feature number<=8, default m is 1.5."<<endl;
     cout<<'\t'<<"-td"<<'\t'<< "Whether the program performs Tucker decomposition [integer, optional]. 1: Yes, 0: No. The default is 1."<<endl;
    cout<<'\t'<<"-td_sampleN"<<'\t'<< "sample feature number on tensor decomposition [integer, optional]. Default is log2(sample_number)."<<endl;
    cout<<'\t'<<"-td_featureN"<<'\t'<< "gene feature number on tensor decomposition [integer, optional]. Default is log2(gene_number)."<<endl;
    cout<<'\t'<<"-gene_select"<<'\t'<< "Whether the program performs gene selection [integer, optional], 1: Yes, 0: No. The default is 1."<<endl;

cout<<"Note: "<<"The arguments -l and -k are mutually exclusive. If both are entered, the program will execute -l. If neither is entered, the program will execute -k and automatically calculate the best k value."<<endl<<endl;
   
            
    cout<<"Please send suggestions or bugs to Yang Zhang at zhangyang@big.ac.cn."<<endl;
}



void saveData2(WholeData wholeData,char *name)
{
    int row=wholeData.sampleNum;
    int col=wholeData.geneNum;
    
    int i,j;
    ofstream outfile;
    
    //打开文件，输出数据
    outfile.open(name,ios::out);
    outfile.setf(ios::fixed);
    outfile.precision(5);
    
    outfile<<"sample";
    outfile<<"\t";
    for(j=0;j<col;j++)
    {
        outfile<<"a"+wholeData.geneName[j]<<"\t";
    }
    //    for(j=0;j<col;j++)
    //    {
    //        outfile<<"b"+wholeData.geneName[j]<<"\t";
    //    }
    //    for(j=0;j<col;j++)
    //    {
    //        outfile<<"c"+wholeData.geneName[j]<<"\t";
    //    }
    outfile<<endl;
    
    
    for(i=0;i<row;i++)
    {
        outfile<<wholeData.sampleName[i]<<"\t";
        for (int t = 0; t<wholeData.typeNum; t++) {
            for(j=0;j<col;j++)
            {
                outfile<<wholeData.Data[i][j][t]<<"\t";
            }
        }
        outfile<<endl;
    }
    
    
    outfile.close();
    
}




//out samples and labels
void saveData4(WholeData wholeData1,int*result,char *name)
{
    int row=wholeData1.sampleNum;
    
    
    int i;
    ofstream outfile;
    
    
    outfile.open(name,ios::out);
    outfile.setf(ios::fixed);
    outfile.precision(5);
    
    outfile<<"sample";
    outfile<<"\n";
    
    
    for(i=0;i<row;i++)
    {
        outfile<<wholeData1.sampleName[i]<<"\t";
        
        outfile<<result[i]+1;
        outfile<<"\n";
    }
    
    outfile<<endl;
    outfile.close();
    
}

void saveData5(WholeData wholeData,int*result,char *name)
{
    int row=wholeData.sampleNum;
    int col=wholeData.geneNum;
    
    int i,j;
    ofstream outfile;
    
   
    outfile.open(name,ios::out);
    outfile.setf(ios::fixed);
    outfile.precision(5);
    
    outfile<<"sample";
    outfile<<"\t";
    
    if (wholeData.typeNum==3) {
        for(j=0;j<col;j++)
        {
            outfile<<"a"+wholeData.geneName[j]<<"\t";
        }
        for(j=0;j<col;j++)
        {
            outfile<<"b"+wholeData.geneName[j]<<"\t";
        }
        for(j=0;j<col;j++)
        {
            outfile<<"c"+wholeData.geneName[j]<<"\t";
        }
        outfile<<"k";
        outfile<<"\n";
    }
    else if (wholeData.typeNum==2){
        for(j=0;j<col;j++)
        {
            outfile<<"a"+wholeData.geneName[j]<<"\t";
        }
        for(j=0;j<col;j++)
        {
            outfile<<"b"+wholeData.geneName[j]<<"\t";
        }
        
        outfile<<"k";
        outfile<<"\n";
    }
    else if (wholeData.typeNum==1){
        for(j=0;j<col;j++)
        {
            outfile<<wholeData.geneName[j]<<"\t";
        }
        
        outfile<<"k";
        outfile<<"\n";
    }
    
    
    for(i=0;i<row;i++)
    {
        outfile<<wholeData.sampleName[i]<<"\t";
        for (int t = 0; t<wholeData.typeNum; t++) {
            for(j=0;j<col;j++)
            {
                outfile<<wholeData.Data[i][j][t]<<"\t";
            }
        }
        outfile<<"class"<<result[i]<<"\n";
        
    }
    
    
    outfile.close();
    
}

void saveImportanceGene(WholeData wholeData,int*importIndex,int importNum,string name)
{
    int row=wholeData.sampleNum;
    int col=importNum;
    
    int i,j;
    ofstream outfile;
    
 
    outfile.open(name.c_str(),ios::out);
    outfile.setf(ios::fixed);
    outfile.precision(5);
    
    outfile<<"sample";
    outfile<<"\t";
    
    if (wholeData.typeNum==3) {
        for(j=0;j<col;j++)
        {
            outfile<<"a"+wholeData.geneName[importIndex[j]]<<"\t";
        }
        for(j=0;j<col;j++)
        {
            outfile<<"b"+wholeData.geneName[importIndex[j]]<<"\t";
        }
        for(j=0;j<col;j++)
        {
            outfile<<"c"+wholeData.geneName[importIndex[j]]<<"\t";
        }
        outfile<<"k";
        outfile<<"\n";
    }
    else if (wholeData.typeNum==2){
        for(j=0;j<col;j++)
        {
            outfile<<"a"+wholeData.geneName[importIndex[j]]<<"\t";
        }
        for(j=0;j<col;j++)
        {
            outfile<<"b"+wholeData.geneName[importIndex[j]]<<"\t";
        }
        
        outfile<<"k";
        outfile<<"\n";
    }
    else if (wholeData.typeNum==1){
        for(j=0;j<col;j++)
        {
            outfile<<wholeData.geneName[importIndex[j]]<<"\t";
        }
        
        //        outfile<<"k";
        outfile<<"\n";
    }
    
    
    for(i=0;i<row;i++)
    {
        outfile<<wholeData.sampleName[i]<<"\t";
        for (int t = 0; t<wholeData.typeNum; t++) {
            for(j=0;j<col;j++)
            {
                outfile<<wholeData.rawData[i][importIndex[j]][t]<<"\t";
            }
        }
        outfile<<"\n";
        
    }
    
    
    outfile.close();
    
}

void saveImportanceGene2(WholeData wholeData,int typeId,int*importIndex,float* importance_mean,float value,int importNum,string name)
{
    int row=wholeData.sampleNum;
    int col=importNum;
    
    int i,j;
    ofstream outfile;
    
   
    outfile.open(name.c_str(),ios::out);
    outfile.setf(ios::fixed);
    outfile.precision(5);
    
    outfile<<"sample";
    
    for(j=0;j<row;j++)
    {
        outfile<<"\t"<<wholeData.sampleName[j];
    }
    
    outfile<<"\n";
    
    
    
    for(i=0;i<col && importance_mean[importIndex[i]]>value;i++)
    {
        outfile<<wholeData.geneName[importIndex[i]];
        
        for(j=0;j<row;j++)
        {
            outfile<<"\t"<<wholeData.rawData[j][importIndex[i]][typeId];
            
        }
        
        outfile<<"\n";
        
    }
    
    
    outfile.close();
    
}




