/******************************************************************
 * Copyright (c) 2021
 * All rights reserved.
 
 * Filename: base.h
 
 * Version: 1.0
 * Author: Yang Zhang  (zhangyang@big.ac.cn)
 * Date: December, 2021
 
 ******************************************************************/

#ifndef base_h
#define base_h
#define W 10 //data type



/* Stanard lib of C++ */
#include<string>
#include<iostream>
#include<sstream>
#include<fstream>
#include<vector>
#include<stdlib.h>
#include<math.h>
#include<time.h>
#include<cmath>
#include "algorithm.h"



using namespace std;
/*****Global variables*****/
extern int N;
extern int M;

extern string* input_filename;
extern string output_filename;
extern string out_runlog;
extern string out_importance;
extern double p_value;
extern int td_sampleN;
extern int td_featureN;
extern float fcm_m_value;
extern int gene_select;
extern clock_t t_start;
extern clock_t t_end;
//Data
struct WholeData {
    int sampleNum=0;
    int geneNum=0;
    int typeNum=0;
    string *sampleName;
    string *geneName;
    float ***Data;//Data[sampleNum][geneNum][typeNum]
    float *** rawData;
    int geneNullNum=0;
    int* geneNullsign;
    

    string* labelType;
    string * sample_label;

    
//    string *significant_type;
//    int ***significant_sign; //[0~15][k][k],define 0
    string ** specific;//[geneId][type]
    int **gene_significant_type; //[geneId][type]=0~15
    int **significant_type_num; //[type]
    float ****gene_class_significant; //[geneId][type][k1][kn],define 1

};



//
string getTime();

vector<string> split(const string &s, const string &seperator);
   string stringtoUpper(string str);
    int CountRow(string filename);
    int CountCol(string filename);
    
    void DataRead1(WholeData &WholeData,int typenum,string* filename);//row is sample
    void DataRead0(WholeData &WholeData,int typenum,string* filename);//col is sample
void ReadLabel(float* &label,int &k,string* &labelType,string* &labelName, int row,string filename,string *sampleName);
void countType(int &typeNum, string* &_type, string* _label,int row);
    void Standardize(float*** &data,int row,int col,int depth);
    void FreeWholeData(WholeData wholeData);
void parseParameter(int &typenum,string* &seq_filename,string &output_filename,int &fileType,string &label_filename,int &k,double &p_value,int &tensorDe,int &td_sampleN,int &td_featureN,float &fcm_m_value,int &gene_select,int argc, const char* argv[]);
int fileSuffixType(string* input_filename,int datatypeNum,string label_filename);



void input();
  void helpInfo();


void countType2(int* &label, int* result,int row);


//output
void saveData4(WholeData wholeData1,int*result,char *name);
void saveData5(WholeData wholeData,int*result,char *name);
void saveData2(WholeData wholeData,char *name);
void saveImportanceGene(WholeData wholeData,int*importIndex,int importNum,string name);
void saveImportanceGene2(WholeData wholeData,int typeId,int*importIndex,float* importance_mean,float value,int importNum,string name);


#endif /* base_h */

